﻿#define _CRT_SECURE_NO_WARNINGS
#include <iostream>
#include <algorithm>
#include <vector>
#include <deque>
#include <map>
#include <set>
#include <cmath>
#include <iomanip>
#include <cstdio>
#include <bitset>
#include <random>
#include <ctime>
#include <queue>
#include <cassert>
#include <array>
#include <unordered_map>
#include <unordered_set>
#define endl '\n'

using namespace std;
using ll = long long;
using ld = long double;
const ll M = 1e9 + 7, MAX = 1;
ll st[MAX];
struct Hash {
	vector <ll> hsh;
	void build(string s) {
		hsh.resize(s.size());
		hsh[0] = s[0] - 'a' + 1;
		for (int i = 1; i < s.size(); i++)
			hsh[i] = (hsh[i - 1] * 34 + s[i] - 'a' + 1) % M;
	}
	ll get(int l, int r) {
		if (l)
			return (hsh[r] - (hsh[l - 1] * st[r - l + 1]) % M + M) % M;
		return hsh[r];
	}
};
vector <int> zf(string s) {
	int n = s.size(), l = 0, r = 0;
	vector <int> z(n);
	for (int i = 1; i < n; i++) {
		z[i] = max(0, min(r - i, z[i - l]));
		while (z[i] + i < n && s[z[i] + i] == s[z[i]])
			z[i]++;
		if (z[i] + i > r)
			r = z[i] + i, l = i;
	}
	return z;
}

ll get(int W, int H, int w, int h) {
	return (W / w + bool(W % w)) * 1ll * (H / h + bool(H % h));
}

void solve() {
	ll W, H, w, h, x, y;
	cin >> W >> H >> w >> h >> x >> y;
	H -= y;
	cout << get(x, H, w, h) + get(W - x, H, w, h) - 1 
		+ get(x, y, w, h) + get(W - x, y, w, h);;
}

int main() {
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
#else 
	ios_base::sync_with_stdio(0);
	cin.tie(0);
#endif 
	st[0] = 1;
	for (int i = 1; i < MAX; i++)
		st[i] = (st[i - 1] * 34) % M;
	
	int t;
	cin >> t;
	while (t--) {
		solve();
		cout << endl;
	}
}
